package logica;

import java.util.List;
import java.util.Vector;

public class HexFile {

	private Vector<HexRecord> hexList;

	public HexFile(){
		hexList = new Vector<HexRecord>();
	}
	public Vector<HexRecord> getHexList() {
		return hexList;
	}

	public void setHexList(Vector<HexRecord> hexList) {
		this.hexList = hexList;
	}
	
	public void addRecord(HexRecord hr){
		hexList.add(hr);
	}
	
	public Vector<DataHexRecord> getRecords(int startAddress,int endAddress){
		Vector<DataHexRecord> vdr = new Vector<DataHexRecord>();
		for (int i=0 ; i<hexList.size() ;i++){
			HexRecord hr = hexList.elementAt(i);
			if (hr.getRectype()==HexRecord.DATA_RECORD){
				if (hr.getLinearAddress()>=startAddress && hr.getLinearAddress()<=endAddress){
					//chequeo si el registro entra entero
					byte[] data= hr.getBinData();
					if ((hr.getLinearAddress() + data.length)<= endAddress){
						vdr.add(hr.getDataHexRecord()); //si entra lo agrego entero  
					}
					else {
						vdr.add(hr.getDataHexRecord(endAddress-hr.getLinearAddress()));//agrego hasta donde pueda
					}
				}
			}
		}
		return vdr;
	}
	
}
